<?php
namespace App\Http\Controllers\API;
use Illuminate\Http\Request; 
use App\Http\Controllers\Controller; 
use App\User;
use App\password_reset;
use Illuminate\Auth\Events\Validated;
use Illuminate\Support\Facades\Auth; 
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;


use Validator;
class UserController extends Controller 
{
public $successStatus = 200;
/** 
     * login api 
     * 
     * @return \Illuminate\Http\Response 
     */ 
    public function login(Request $request){ 
        if(Auth::attempt(['email' => $request['email'], 'password' => $request['password']])){ 
            $user = Auth::user(); 
            
            $success['token'] =  $user->createToken('MyApp')-> accessToken;
            error_log(print_r($user, true));
            return response()->json(['user'=>['id'=>$user['id'],'fname'=>$user['first_name'], 'lanme'=>$user['last_name'],'email'=>$user['email'], 'role'=>$user['role']],'token'=>$success['token']], $this-> successStatus); 
        } 
        else{ 
            return response()->json(['error'=>'Unauthorised'], 401); 
        } 
    }
/** 
     * Register api 
     * 
     * @return \Illuminate\Http\Response 
     */ 
    public function register(Request $request) 
    {
        $input = $request->all(); 
        $this->request = $request->all();
        $input['password'] = bcrypt($input['password']);
        $user = User::create($input); 
        $success['token'] =  $user->createToken('MyApp')-> accessToken; 
        $success['name'] =  $user->name;
        $user->api_token=$success['token']; 
        $user->remember_token=$success['token'];
        $user->save();

        $mail = json_decode(DB::table('mails')->where(['catagory'=>0])->get());
        $body = $mail[0]->body;
        $subject = $mail[0]->subject;
        error_log(print_r($request->all(), true));
        $body = str_replace('{first_name}', $request['first_name'], $body);
        $subject = str_replace('{first_name}', $request['first_name'], $subject);
        $body = str_replace('{last_name}', $request['last_name'], $body);
        $subject = str_replace('{last_name}', $request['last_name'], $subject);

        $this->subject = $subject;

        error_log(print_r(($body), true));
        Mail::html( $body,function($message){
            $message->to($this->request['email'])
                    ->subject($this->subject);
            $message->from('noreply@tid.nu');
        });

        //error_log(print_r(json_decode($user), true));
    return response()->json(['user'=>['id'=>$user['id'],'fname'=>$user['first_name'], 'lname'=>$user['last_name'], 'email'=>$user['email'], 'role'=>$user['role']],'token'=>$success['token']], $this-> successStatus); 
    }
/** 
     * details api 
     * 
     * @return \Illuminate\Http\Response 
     */ 
    public function details() 
    { 
        $user = Auth::user(); 
        return response()->json(['success' => $user], $this-> successStatus); 
    } 

    public function passwordReset(Request $request)
    {
        $validator = Validator::make($request->all(),[
            'email'=>['required', 'email']
        ]);
        $this->request = $request->all();
        if($validator->fails()) {
            error_log(print_r($validator->errors(), true));
            return response()->json(['error'=>$validator->errors()->message()], 401);    
        }
        $pin = mt_rand(000000,999999);
        $user = DB::table('users')->where('email',$request['email'])->get();
        $pass = json_decode(DB::table('password_reset')->where(['user_id'=> $user[0]->id])->get());

        $mail = json_decode(DB::table('mails')->where(['catagory'=>2])->get());

        $body = $mail[0]->body;
        $subject = $mail[0]->subject;

        $body = str_replace('{pin}', $pin, $body);
        $subject = str_replace('{pin}', $pin, $subject);
        $this->subject = $subject;
        if($pass){
            Mail::html( $body, function($message){
                $message->to($this->request['email'])
                        ->subject($this->subject);
                $message->from('noreply@tid.nu');
            });
            DB::table('password_reset')->where(['user_id' => $user[0]->id])->update(['verification_code'=> $pin]);
        }else{
            Mail::html( $body, function($message){
                $message->to($this->request['email'])
                        ->subject($this->subject);
                $message->from('noreply@tid.nu');
            });
            DB::table('password_reset')->insert(['user_id' => $user[0]->id, 'verification_code'=> $pin]);
        }
        return response()->json(['data'=>'Password reset mail sent successfully']);
    }

    public function setPassword(Request $request)
    {
        $user = User::where('email',$request['email'])->get();
        $details = json_decode(DB::table('password_reset')->where(['user_id'=>$user[0]->id,'verification_code'=> $request['verification_code']])->get());
        if($details){
            User::where(['id' => $details[0]->user_id])->update(['password'=> bcrypt($request['password'])]);
            DB::table('password_reset')->where(['id' => $details[0]->id])->delete();
            return response()->json(['data'=>'Password changes successfully']);
        }
        else
            return response()->json(500);
    }

    public function socialLogin(Request $request)
    {
        $user = json_decode(User::where(['email'=>$request['email']])->get());
        error_log(print_r($user,true));
        if($user)
            return $this->login($request);
        else
            return $this->register($request);
    }

    public function findAccount(Request $request)
    {
        $user = json_decode(User::where(['email'=>$request['email']])->get());
        if($user)
            return response()->json(true);
        return response()->json(false);
    }
}