<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\schedules;
use App\participants;
use App\schedule_dates;
use Illuminate\Routing\Route;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;

class schedule_controller extends Controller
{
    public function Test()
    {
        return response()->json(['message'=>'I am calles']);
    }

    public function newEvent(Request $request)
    {
        error_log(print_r($request->all(), true));
        $times = json_decode(($request['time']));
        $link = $this->generateEventCode();
        if($request['deadlineDate'])
            $config['deadlineDate'] = $request['deadlineDate'];
        else
            $config['deadlineDate'] = null;
        if($request['ci0'] == "undefined") $ci0 = NULL;
        else $ci0 = $request['ci0'];
        if($request['ci1'] == "undefined") $ci1 = NULL;
        else $ci1 = $request['ci1'];
        if($request['ci2'] == "undefined") $ci2 = NULL;
        else $ci2 = $request['ci2'];
        if($request['ci3'] == "undefined") $ci3 = NULL;
        else $ci3 = $request['ci3'];
        if($request['ci4'] == "undefined") $ci4 = NULL;
        else $ci4 = $request['ci4'];
        $schedule = schedules::create([
            'user_id' => $request['user_id'],
            'username' =>$request['username'],
            'title' => $request['title'],
            'location' => $request['location'],
            'description' => $request['description'],
            'theme' => $request['theme'],
            'reply_deadline' => $request['deadlineReply'],
            'reply_deadline_date' => $config['deadlineDate'],
            'if_needed_option' => $request['ifNeeded'],
            'one_answer' => $request['oneAns'],
            'hidden_schedule' => $request['hidSchedule'],
            'ask_for_contact' => $request['contactInfo'],
            'limit_access' => $request['adminOnly'],
            'schedule_link' => $link,
            'custom_theme' => $request['customtheme'],
            'contact_info1' =>$ci0,
            'contact_info2' =>$ci1,
            'contact_info3' =>$ci2,
            'contact_info4' =>$ci3,
            'contact_info5' =>$ci4,

        ]);
            $title=$request['title'];
            if($request['location'])
                $location = $request['location'];
            else $location = null;
            if($request['description'])            
                $desc = $request['description'];
            else $desc = null;


            $mail = json_decode(DB::table('mails')->where(['catagory'=>1])->get());

        $body = $mail[0]->body;
        $subject = $mail[0]->subject;


        $body = str_replace('{title}', $title, $body);
        $subject = str_replace('{title}', $title, $subject);
        $body = str_replace('{description}', $desc, $body);
        $subject = str_replace('{description}', $desc, $subject);
        $body = str_replace('{location}', $location, $body);
        $subject = str_replace('{location}', $location, $subject);
        $subject = str_replace('{link}', $link, $subject);
        $body = str_replace('{link}', $link, $body);


        $schedule->save();
        $user = json_decode(DB::table('users')->where(['id'=>$request['user_id']])->get());
        $this->email = $user[0]->email;
        $scheduleMail = "<table border='1' style='width:400px'><tr><th>Date</th><th>From</th><th>To</th></tr>";
        foreach($times as $time){
            if(!$time->stime)
                $time->stime = null;
            if(!$time->ftime)
                $time->stime = null;
            $scheduleMail .= "
            <tr>
                <td>$time->date</td>
                <td>'$time->stime'</td>
                <td>$time->ftime'</td>
            </tr>";

            schedule_dates::create([
                'schedule_id' => $schedule->id,
                'schedule_date' => $time->date,
                'time_from' => $time->stime,
                'time_to' => $time->ftime
            ]);
        }

        $scheduleMail .= "</table><p>You can add participant on: http://tid.nu/$link</p>";

        $body = str_replace('{schedule}', $scheduleMail, $body);
        $this->subject = $subject;

        Mail::html($body, function($message){
            $message->to($this->email)
                    ->subject($this->subject);
            $message->from('noreply@tid.nu');
        });

        return response()->json(['message'=>'Schedule Registered','link'=>$link ]);
    }

    public function generateEventCode()
    {
        $token = "";
        $codeAlphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        $codeAlphabet.= "0123456789";
        $codeAlphabet .= "abcdefghijklmnopqrstuvwxyz";

        for($i=0;$i<8;$i++){
            $token .= $codeAlphabet[mt_rand(0,strlen($codeAlphabet)-1)];
        }
        return $token;
    }
    public function getScheduleDetails(Request $request)
    {
        $schedule = json_decode(DB::table('schedules')->where('schedule_link', $request['link'])->get());
        $dates = json_decode(DB::table('schedule_dates')->where('schedule_id',$schedule[0]->id)->get());
        $participants = json_decode(DB::table('participants')->where('schedule_id',$schedule[0]->id)->get());
        if($participants)
        $participants_dates = json_decode(DB::table('participant_date')->where('schedule_id',$participants[0]->schedule_id)->get());
        else
        $participants_dates=null;
        return response()->json(['schedule'=>$schedule,'time'=>$dates,'participants'=>$participants, 'participants_date'=>$participants_dates]);
    }

    public function addParticipant(Request $request)
    {
        error_log(print_r($request['ci0'], true));
        $dates = json_decode($request['dates']);
        $participant = participants::create(['user_id'=>$request['user_id'],
                                            'name'=>$request['name'],
                                            'comment'=>$request['comment'],
                                            'schedule_id'=>$request['schedule_id'],
                                            'comment'=> $request['comment'], 
                                            'ci0'=>$request['ci0'],
                                            'ci1'=>$request['ci1'],
                                            'ci2'=>$request['ci2'],
                                            'ci3'=>$request['ci3'],
                                            'ci4'=>$request['ci4']]);
        $participant->save();
        foreach($dates->dates as $date){
            if($date->status == 0)
                $temp='0';
            else if($date->status == 1)
                $temp = '1';                                                                                                                                                                              
            else $temp = '2';
            DB::table('participant_date')->insert(['participant_id'=>$participant->id, 'schedule_id'=>$request['schedule_id'], 'schedule_date_id'=> (string)$date->id, 'participant_status'=>$temp]);
        }
        $participantID = DB::table('participants')->where(['user_id'=>$request['user_id'], 'schedule_id'=>$request['schedule_id']])->latest()->first();
        $comments  = json_decode($request['DateComments']);
        foreach($comments as $comment){
            DB::table('participant_date')->where(['participant_id'=>$participantID->id, 'schedule_date_id'=>$comment->id])->update(['comment'=>$comment->comment]);
        }
    }

    public function outgoingschedules(Request $request)
    {
        $id = $request->route('id');
        $schedules = json_decode(DB::table('schedules')->where(['user_id'=>$id])->get());
        return response()->json(['schedule'=>$schedules]);
    }

    public function incomingschedules(Request $request)
    {
        $id = $request->route('id');
        $schedules = DB::select(DB::raw("SELECT * from schedules WHERE id IN(SELECT schedule_id FROM participants where user_id = '$id' GROUP BY(schedule_id))"));
        return response()->json(['schedule'=>$schedules]);
    }

    public function showSchedule(Request $request)
    {
        $schedule = json_decode(DB::table('schedules')->where('id', $request->route('id'))->get());
        $dates = json_decode(DB::table('schedule_dates')->where('schedule_id',$schedule[0]->id)->get());
        $participants = json_decode(DB::table('participants')->where('schedule_id',$schedule[0]->id)->get());
        error_log(print_r($participants, true));
        if($participants)
            $participants_dates = json_decode(DB::table('participant_date')->where('schedule_id',$participants[0]->schedule_id)->get());
        else
            $participants_dates=null;
        return response()->json(['schedule'=>$schedule,'time'=>$dates,'participants'=>$participants, 'participants_date'=>$participants_dates]);
    }

    public function logRequests(Request $request)
    {
        error_log(print_r($request->all(), true));
        return 'success';
    }
}
