<?php
require_once(dirname(__FILE__).'/boot.php');
require_once(SG_PUBLIC_INCLUDE_PATH.'/header.php');
require_once(SG_BACKUP_PATH.'SGBackupSchedule.php');
$allSchedules = SGBackupSchedule::getAllSchedules();
require_once(SG_PUBLIC_INCLUDE_PATH.'sidebar.php');
?>

<div id="sg-content-wrapper">
    <div class="container-fluid">
        <div class="sg-schedule-container">
            <fieldset>
                <legend><?php _backupGuardT('Schedules')?><?php echo backupGuardLoggedMessage(); ?></legend>
                <button class="pull-left btn btn-success" data-toggle="modal" data-modal-name="create-schedule" data-remote="modalCreateSchedule"><i class="glyphicon glyphicon-plus"></i> <?php _backupGuardT('Create schedule')?></button>
                <div class="clearfix"></div><br/>
                <table class="table table-striped paginated sg-backup-table">
                    <thead>
                    <tr>
                        <th><?php _backupGuardT('Label')?></th>
                        <th><?php _backupGuardT('Recurrence')?></th>
                        <th><?php _backupGuardT('Execution date')?></th>
                        <th><?php _backupGuardT('Backup options')?></th>
                        <th><?php _backupGuardT('Upload to')?></th>
                        <th><?php _backupGuardT('Status')?></th>
                        <th><?php _backupGuardT('Actions')?></th>
                    </tr>
                    </thead>
                    <tbody>
                        <?php if(empty($allSchedules)): ?>
                            <tr>
                                <td colspan="7"><?php _backupGuardT('No schedules found.')?></td>
                            </tr>
                        <?php endif; ?>
                        <?php foreach ($allSchedules as $schedule):
                            $backupOptions = backupGuardParseBackupOptions($schedule);
                        ?>
                            <tr>
                                <td><?php echo htmlspecialchars($schedule['label'])?></td>
                                <td><?php echo htmlspecialchars($schedule['recurrence'])?></td>
                                <td><?php echo backupGuardConvertDateTimezone(@date('Y-m-d H:i:s', (int)$schedule['executionDate']))?></td>
                                <td>
                                <?php
                                    $showOptions = array();
                                    if (!$backupOptions['isCustomBackup']) {
                                        $showOptions[] = 'Full';
                                    }
                                    else {
                                        if ($backupOptions['isDatabaseSelected']) {
                                            $showOptions[] = 'DB';
                                        }
                                        if ($backupOptions['isFilesSelected']) {
                                            $selectedDirectories = str_replace('wp-content/', '', $backupOptions['selectedDirectories']);
                                            if (in_array('wp-content', $selectedDirectories)) {
                                                $showOptions[] = 'wp-content';
                                            }
                                            else {
                                                $showOptions = array_merge($showOptions, $selectedDirectories);
                                            }
                                        }
                                    }
                                    echo implode(', ', $showOptions);
                                ?>
                                </td>
                                <td>
                                    <?php
                                        foreach ($backupOptions['selectedClouds'] as $cloud) {
                                            echo '<span class="btn-xs sg-status-icon sg-status-3'.$cloud.' active">&nbsp;</span> ';
                                        }
                                    ?>
                                </td>
                                <td><?php echo (int)$schedule['status']==SG_SHCEDULE_STATUS_PENDING? _backupGuardT('Pending'):_backupGuardT('Inactive')?></td>
                                <td>
                                    <button data-toggle="modal" data-modal-name="create-schedule" data-remote="modalCreateSchedule" data-sgbp-params="<?php echo $schedule['id']?>" class="btn btn-primary btn-xs" title="<?php _backupGuardT('Edit')?>">&nbsp;<i class="glyphicon glyphicon-pencil" aria-hidden="true"></i>&nbsp;</button>
                                    <button onclick="sgBackup.removeSchedule(<?php echo $schedule['id']?>)" class="btn btn-danger btn-xs" title="<?php _backupGuardT('Delete')?>">&nbsp;<i class="glyphicon glyphicon-remove" aria-hidden="true"></i>&nbsp;</button>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
                <div class="text-right">
                    <ul class="pagination"></ul>
                </div>
            </fieldset>
        </div>
    </div>
    <?php require_once(SG_PUBLIC_INCLUDE_PATH.'/footer.php'); ?>
</div>
